const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_batchsummary_detailhtd', {
    SerNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Date: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Time: {
      type: DataTypes.TIME,
      allowNull: true
    },
    InstrumentID: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    MinHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MinThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MinDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MinBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TestResult: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    UserID: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    NoOfSample: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Min: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Avg: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Deviation: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    MinTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    MaxTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    AvgTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    Min_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    SFOID: {
      type: DataTypes.STRING(500),
      allowNull: false,
      defaultValue: "NA"
    },
    Repetition:{
      type: DataTypes.INTEGER,
      allowNull: true,
      default: 0
    },
  }, {
    sequelize,
    tableName: 'tbl_batchsummary_detailhtd',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_batc__7982B6002E62B424",
        unique: true,
        fields: [
          { name: "RepSerNo" },
        ]
      },
    ]
  });
};
